﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace iXTankenSimple
{
    public class AddNewViewModel:ViewModelBase
    {
        private TankVorgang _newTankVorgang= null;

        public AddNewViewModel()
        {
            _CommitDataCommand = new DelegateCommand(this.CommitDataAction);
            _RollbackDataCommand = new DelegateCommand(this.RollbackDataAction);

            NewTankVorgang = new TankVorgang();
        }

        private ICommand _CommitDataCommand;

        public ICommand CommitDataCommand
        {
            get
            {
                return _CommitDataCommand;
            }
        }

        private void CommitDataAction(object p)
        {
            ITankvorgangModelService tankvorgangModelService = this.GetService<ITankvorgangModelService>();
            if (tankvorgangModelService == null)
            {
                return;
            }

            tankvorgangModelService.AddNewTankVorgang(NewTankVorgang);

            INavigationService tankVorgangNavigationService = this.GetService<INavigationService>();
            if (tankVorgangNavigationService == null)
            {
                return;
            }

            tankVorgangNavigationService.NavigateBack();
        }

        private ICommand _RollbackDataCommand;

        public ICommand RollbackDataCommand
        {
            get
            {
                return _RollbackDataCommand;
            }
        }

        private void RollbackDataAction(object p)
        {
           
            INavigationService tankVorgangNavigationService = this.GetService<INavigationService>();
            if (tankVorgangNavigationService == null)
            {
                return;
            }

            tankVorgangNavigationService.NavigateBack();
        }

        public DateTime Datum
        {
            get
            {
                return NewTankVorgang.Datum;
            }
            set
            {
                if (NewTankVorgang.Datum != value)
                {
                    NewTankVorgang.Datum = value;
                    RaisePropertyChanged("Datum"); 
                }
            }
        }

        public Double Kilometerstand 
        {
            get
            {
                return NewTankVorgang.Kilometerstand;
            }
            set
            {
                if (NewTankVorgang.Kilometerstand != value)
                {
                    NewTankVorgang.Kilometerstand = value;
                    RaisePropertyChanged("Kilometerstand");
                }
            }
        }

        public Double Menge 
        {
            get
            {
                return NewTankVorgang.Menge;
            }
            set
            {
                if (NewTankVorgang.Menge != value)
                {
                    NewTankVorgang.Menge = value;
                    RaisePropertyChanged("Menge");
                }
            }
        }

        public Double Betrag 
        {
            get
            {
                return NewTankVorgang.Betrag;
            }
            set
            {
                if (NewTankVorgang.Betrag != value)
                {
                    NewTankVorgang.Betrag = value;
                    RaisePropertyChanged("Betrag");
                }
            }
        }

        public String Anmerkung 
        {
            get
            {
                return NewTankVorgang.Anmerkung;
            }
            set
            {
                if (NewTankVorgang.Anmerkung != value)
                {
                    NewTankVorgang.Anmerkung = value;
                    RaisePropertyChanged("Anmerkgung");
                }
            }
        }

        public TankVorgang NewTankVorgang
        { 
            get 
            {
                return this._newTankVorgang;
            }
            set 
            { 
                if (this._newTankVorgang != value) 
                {
                    this._newTankVorgang = value;
                    this.NewTankVorgang.Datum = value.Datum; 
                } 
            }
        }
    }
}
